/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2024. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/

dojo.provide("com.ibm.team.tpt.shared.common.internal.providers.ExposureProvider");

(function() {

dojo.declare("com.ibm.team.tpt.shared.common.internal.providers.ExposureProvider", null, {

   getValue: function(attribute, workItem, configuration) {

      var impactAttribute= configuration.getChild("impactAttribute").getIdentifier();
      var probabilityAttribute= configuration.getChild("probabilityAttribute").getIdentifier()

      var impact= this.__getLastIntSegment(workItem.getValue(impactAttribute));
      var probability= this.__getLastIntSegment(workItem.getValue(probabilityAttribute));

      return (impact * probability) / 100;
   },

   __getLastIntSegment: function(identifier) {
      if (identifier != null) {
         var lastSeparator= identifier.lastIndexOf('.');
         var numberString= identifier.substring(lastSeparator+2);
         return parseInt(numberString, 10);
      }
      return -1;
   },

   __sentinel: null
});

})();