/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2024. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:  
 * Use, duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp. 
 *******************************************************************************/
dojo.provide("com.ibm.team.workitem.attribute.wsjfValueProvider");

(function() {
	var doDebug= true; 
    var scriptName= "wsjfCalculator";
	
dojo.declare("com.ibm.team.workitem.attribute.wsjfValueProvider", null, {

        getValue: function(attribute, workItem, configuration) {
        		// Grab the enumeration label for each of the WSJF component attributes  
			var jobSizeLabel= workItem.getLabel("com.ibm.team.workitem.attribute.jobSize");
			var ubValLabel= workItem.getLabel("com.ibm.team.workitem.attribute.ubVal");
			var timeCritLabel= workItem.getLabel("com.ibm.team.workitem.attribute.timeCrit"); 
			var rroeLabel= workItem.getLabel("com.ibm.team.workitem.attribute.rroe");

			// Declare the numeric WSJF attributes
			var jobSize= 0, ubVal= 0, timeCrit= 0, rroe= 0, wsjf= 0; 
			
			// Set the numeric attributes based on the enumeration label
			// User/Business Value
			ubVal= calc(ubValLabel, 0);
			if (ubVal == 0) {
				return wsjf;
			}
			
			// Time Criticality
			timeCrit= calc(timeCritLabel, 0);
			if (timeCrit == 0) {
				return wsjf;
			}

			// RR/OE
			rroe= calc(rroeLabel, 0);
			if (rroe == 0) {
				return wsjf;
			}

			// Job Size
			jobSize= calc(jobSizeLabel, 0);
			if (jobSize == 0) {
				return wsjf;
			}

			var costOfDelay= ubVal + timeCrit + rroe; 
			
			wsjf= parseFloat((costOfDelay / jobSize).toFixed(2));

			return wsjf;

			function calc(a_label, default_val) {	
				var result= default_val;
		    		switch (a_label) {
					case '1': 
						result= 1; 
						break;
					case '2': 
						result= 2;
						break;
					case '3':
						result= 3;
						break;
					case '5': 
						result= 5;
						break;
					case '8': 
						result= 8;
						break;
					case '13':
						result= 13;
						break;
					case '21':
						result= 21;
						break; 
			    	}
		    	return result;
			}
        }
	});
})();