/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2024. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:  
 * Use, duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp. 
 *******************************************************************************/
dojo.provide("com.ibm.team.workitem.attribute.achievedValueProvider");

(function() {
	
dojo.declare("com.ibm.team.workitem.attribute.achievedValueProvider", null, {

        getValue: function(attribute, workItem, configuration) {
        	// Grab the enumeration label for business value attributes  
			var busValuePlannedLabel= workItem.getLabel("com.ibm.team.workitem.attribute.busValuePlanned");
			var busValueActualLabel= workItem.getLabel("com.ibm.team.workitem.attribute.busValueActual");
			
			// Declare the numeric business value attributes
			var busValPlanned= 0, busValActual= 0; 
			
			// Set the numeric attributes based on the enumeration label
			// Business Value (planned)
			busValPlanned= calc(busValuePlannedLabel, 1);

			// Business Value (actual)
			busValActual= calc(busValueActualLabel, 1);

			var achievedValueRatio = 0;
            var achievedValue = 0;
            if (busValPlanned > 0 & busValActual > 0) {
                achievedValueRatio= Number(busValActual / busValPlanned);
                achievedValue= achievedValueRatio * 100;
            }
			return achievedValue;

			function calc(a_label, default_val) {	
				var result= default_val;
		    		switch (a_label) {
		    		case '0':
		    			result= 0;
		    			break;
					case '1': 
						result= 1; 
						break;
					case '2': 
						result= 2;
						break;
					case '3':
						result= 3;
						break;
					case '4': 
						result= 4;
						break;
					case '5': 
						result= 5;
						break;
					case '6':
						result= 6;
						break;
					case '7':
						result= 7;
						break;
					case '8':
						result= 8;
						break;
					case '9':
						result= 9;
						break;
					case '10':
						result= 10;
						break;	
			    	}
		    	return result;
			}
        }
	});
})();